

#include <windows.h>
#include <windowsx.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <commctrl.h>
#include <commdlg.h>

#include <vfw.h>
#include <GdiPlus.h>
#include "miniGdiPlus.h"


#include "main.h"


  BOOL Remote_webcam;


  BOOL   RXbutton              = TRUE;
  BOOL   TXbutton              = FALSE;
  BOOL   PicStart              = FALSE;
  BOOL   Image_mode            = FALSE;
  BOOL   COLOUR                = TRUE;
  BOOL   IsImageLoaded         = FALSE;

  BOOL   Sending_pic           = FALSE;
  BOOL   Webcam                = TRUE;
extern  BOOL   VERYLARGE_PIC         = FALSE;
extern  BOOL   LARGE_PIC             = TRUE;
extern  BOOL   SMALL_PIC             = FALSE;
extern  BOOL   FAX                   = FALSE;
extern  BOOL   TXwindowOpen          = FALSE;
extern  BOOL   RXwindowOpen          = FALSE;


  HANDLE  hBitmapLeftClickMessage,
          hBitmapTrackbarLabel;
  HWND    hwnd,
          hCtl_TX,
          hwndPicTX,
          hwndPicRX,
          g_hwndTXbutton,
          g_hwndRXbutton,
          hRX,
          hwndWebcam,
          hwndWebcamTX;

  extern  HINSTANCE g_hInst, hThisInstance ;

  BITMAP  bm;
  HBITMAP hTmpBmp;
  HDC     hdcPic, hMarkerDC;
  HPEN    hOldPenmarker, hPenMarker;        

  static  IMAGE img;

  extern int FS;
  DOUBLE two_pi = 2.0 * 3.1415926535;
  double nco_ang = 0.0;
  double I_bu[257];
  double Q_bu[257];
  float  LPF[257];
  int    pixel=0, line=0;
  extern float  channel_offset;

  BYTE  pixR[320*242*30*4];   //make it large enough for the long lines!  Make room for the WEFAX reception (600 x 400)
  BYTE  pix_processed[3200*242*3*4];  //Need to put this outside the routine as not enough space inside routine?
  DWORD pix_display[640*482*4];
  DWORD pix_processed_extended[1600*90*3*4]; //for 10x fine adjustment of picture skew
  DWORD pix_processed_skew[320*242*30*4];    

  int   pic_skew, pic_phase;
  int   picW,tpicW;              //NB. Use separate picW and picH for send functions as will be conflicts if both on at the same time
  int   picH,tpicH;
  int   pic_decimate;

  int line_counter; 

         
extern char filename[];
extern char path_plus_filename[];
extern char full_image_path[];


//==============================================================================
// Get GDI+ encoder class identifiers
//==============================================================================
int GetEncoderClsid(const WCHAR * format, CLSID * pClsid)
{
   UINT num  = 0;   // number of image encoders
   UINT size = 0;   // size of the image encoder array in bytes

   IMAGECODECINFO *pImageCodecInfo = NULL;

   GdipGetImageEncodersSize(&num, &size);
   if (size == 0)
      return -1;   // Failure

   pImageCodecInfo = malloc(size);
   if (pImageCodecInfo == NULL)
      return -1;   // Failure

   GdipGetImageEncoders(num, size, pImageCodecInfo);

   for (UINT j = 0; j < num; ++j)
   {
      if (wcscmp(pImageCodecInfo[j].MimeType, format) == 0)
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;   // Success
      }
   }

   free(pImageCodecInfo);
   return -1;   // Failure
}




//============================================================================================
// Send picture load window and various functions
//============================================================================================
extern LRESULT CALLBACK IMAGE_TX_DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 
 static BITMAPINFO bmi, bmiMarker;
 static HBITMAP    hMarkerBmp;
 static HDC        hTmpDC;
  
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
	   //make sure we do not open more than one instance of the window	   
                TXwindowOpen = TRUE;
                Image_mode   = FALSE;
			    IsImageLoaded   = FALSE;
       //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOP, 10, 10, 0, 0,SWP_SHOWWINDOW | SWP_NOSIZE);     
 
       //Window message to tell users to left click to load image file 
			    DeleteObject(hBitmapLeftClickMessage);  //get rid of the old one to avoid GDI leaks
                hBitmapLeftClickMessage = LoadBitmap(g_hInst, "IMG_BITMAP_LEFT_CLICK");  
                SendMessage(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW) ,STM_SETIMAGE, 0,(LPARAM)hBitmapLeftClickMessage); 

       //default is large pic
                LARGE_PIC = TRUE;   
			    tpicW = 640; tpicH = 480;
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC), BM_SETCHECK,1,0);
			}
			break;


    case WM_CONTEXTMENU:
       {

//Now see if we have a right-click on the image send screen

		{
         wchar_t fileName[MAX_PATH]=L"\x0000";

           OPENFILENAMEW ofn;
           ZeroMemory(&ofn, sizeof(ofn));
           ofn.lStructSize = sizeof(ofn);
           ofn.hwndOwner = hwnd;
           ofn.lpstrFilter =
                    L"All supported graphic formats (*.bmp,*.dib,*.rle,*.ico,*.jpg,*.jpeg,*.jpe,*.jfif,*.gif,*.tif,*.tiff,*.png,*.emf,*.wmf)"
                    L"\0*.bmp;*.dib;*.rle;*.ico;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.tif;*.tiff;*.png;*.emf;*.wmf\0\0";
           ofn.lpstrFile = fileName;
           ofn.nMaxFile = MAX_PATH;
           ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLEHOOK | OFN_ENABLESIZING;// <--OFN_ENABLEHOOK avoids memory leaks

 
         if(GetOpenFileNameW(&ofn))
           {
            DeleteThisImge( &img );
            img = LoadThisImge( fileName );	
	
            HDC hdc=GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));// BeginPaint(hwndPicTX,&ps);
            HDC hdcMem = CreateCompatibleDC (hdc);

            SelectObject(hdcMem,img.hBitmap);   
            SetStretchBltMode(hdc,HALFTONE);        
            StretchBlt(hdc,0,0,640,480, hdcMem,0,0,img.w,img.h,SRCCOPY); 
            DeleteDC(hdcMem);
		    ReleaseDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW),hdc);		
            IsImageLoaded = TRUE;

            DeleteDC(hdc);
            DeleteDC(hTmpDC);                   //Get rid of old objects before loading a new picture
            DeleteObject(hTmpBmp);
            DeleteDC(hMarkerDC);                  
            DeleteObject(hMarkerBmp);	
            DeleteDC(hdcPic);

                                   //Set up a fresh bitmap for the new picture
             hdcPic = GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));           

			 bmi.bmiHeader.biSize        = sizeof(bmi.bmiHeader);
             bmi.bmiHeader.biWidth       = 640;
             bmi.bmiHeader.biHeight      = 480+2;  //make this one larger than the picture (480)
             bmi.bmiHeader.biPlanes      = 1;
             bmi.bmiHeader.biBitCount    = 32;
             bmi.bmiHeader.biCompression = BI_RGB;

 
             hTmpDC = CreateCompatibleDC (hdcPic);
             hTmpBmp = CreateDIBSection(hTmpDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hTmpDC, hTmpBmp);
             BitBlt (hTmpDC, 0, 0, 640, 480, hdcPic, 0, 0, SRCCOPY); //copy picture into bitmap 

//Create a DC for the picture send progress bar (a line that draws horizontally and is not deleted)
			 bmiMarker.bmiHeader.biSize        = sizeof(bmiMarker.bmiHeader);
             bmiMarker.bmiHeader.biWidth       = 10;
             bmiMarker.bmiHeader.biHeight      = 480;
             bmiMarker.bmiHeader.biPlanes      = 1;
             bmiMarker.bmiHeader.biBitCount    = 32;
             bmiMarker.bmiHeader.biCompression = BI_RGB;

             hMarkerDC = CreateCompatibleDC (hdcPic);
             hMarkerBmp = CreateDIBSection(hMarkerDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hMarkerDC, hMarkerBmp); 
             SetForegroundWindow(hwndDlg);     
           }

		 }
	   }	break;


         case WM_TIMER:
            switch (wParam)
             {

			  case 0:    if(line_counter < pic_decimate+1)  //close everything down when the picture has been sent. "line_counter" counts down from 240 in the send audio callback
                             {
                              TXwindowOpen = FALSE;
                              Image_mode   = FALSE;
                              DeleteObject(hMarkerBmp);
                              DeleteDC(hTmpDC);
                              DeleteDC(hMarkerDC);
			                  DeleteDC(hdcPic);
                                     
                              EndDialog(hwndDlg, 0);
                              DestroyWindow(hwndDlg);		
					         }break;
             }
             break;  


		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
   
             case IDC_SEND_PIC_BUTTON:
			  {				
			   if(IsImageLoaded == TRUE)  //If there is a picture from file
				{
	             
				 SetTimer(hwndDlg,0,100,NULL);//Start a watchdog timer to check whether the frame has been sent, and close down the webcam window, ready for a new one
				 Image_mode = TRUE;
                 int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
				 SendMessage(hCtl_TX, EM_SETSEL, len, len);
		         if(VERYLARGE_PIC==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" V");
		         if(LARGE_PIC    ==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" L"); //don't forget the space after the direction call
		         if(SMALL_PIC    ==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" S");
		         if(FAX          ==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" F");


				 SendMessage(g_hwndTXbutton,WM_LBUTTONDOWN,0,0);     //DON'T use PostMessage as the window will lose focus and not return
				 line_counter = 480;
				 PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);             //clear the picture send progress bar
			    }
			   else
				{
				 Image_mode = FALSE;             //If not sending a picture at all!
				}
			    SetForegroundWindow(hwndDlg);	 //This ensures focus is set back to the TX pic window	
		      }          
              break;

           case IDC_SMALL_PIC:
			   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = TRUE;
                FAX           = FALSE;   
				tpicH = 480; tpicW = 640;         //It is always 320x240 for send pic 
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);
			   }
			    break;

           case IDC_LARGE_PIC:
		   	   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = TRUE;
                SMALL_PIC     = FALSE;
                FAX           = FALSE;   
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);
		   	   }
                break;

           case IDC_VERYLARGE_PIC:
		   	   {
                VERYLARGE_PIC = TRUE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = FALSE;
                FAX           = FALSE;   
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);						;
		   	   }
                break;

           case IDC_FAX:
		   	   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = FALSE;
                FAX           = TRUE;
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,1,0);
		   	   }
                break;


          case IDC_PIC_CLIPBOARD:   //paste an image that has been previously copied to the clipboard
             {
              HDC hdc=GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW)); //A lot of repeat code from above!
              HDC hdcMem = CreateCompatibleDC (hdc);

              if(OpenClipboard(hwndDlg))   //this is the new bit
				{
                 HBITMAP hBmp;
                 hBmp = GetClipboardData(CF_BITMAP);
                 SelectObject(hdcMem, hBmp);
                 BITMAP bm;
                 GetObject(hBmp, sizeof(bm), &bm);   //end of new bit

                 SetStretchBltMode(hdc,HALFTONE);        
                 StretchBlt(hdc,0,0,640,480, hdcMem,0,0,bm.bmWidth,bm.bmHeight,SRCCOPY);//img.w,img.h,SRCCOPY); 
                 DeleteDC(hdcMem);
		         ReleaseDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW),hdc);		
                 IsImageLoaded = TRUE;
                 CloseClipboard();
               //  EmptyClipboard();  //??
                 DeleteDC(hdc);
                 DeleteDC(hTmpDC);                   //Get rid of old objects before loading a new picture
                 DeleteObject(hTmpBmp);
                 DeleteDC(hMarkerDC);                  
                 DeleteObject(hMarkerBmp);	
                 DeleteDC(hdcPic);
                 DeleteObject(hBmp);
                }
                                   //Set up a fresh bitmap for the new picture
                 hdcPic = GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));           

			     bmi.bmiHeader.biSize        = sizeof(bmi.bmiHeader);
                 bmi.bmiHeader.biWidth       = 640;
                 bmi.bmiHeader.biHeight      = 480+2;  //make this one larger than the picture (480)
                 bmi.bmiHeader.biPlanes      = 1;
                 bmi.bmiHeader.biBitCount    = 32;
                 bmi.bmiHeader.biCompression = BI_RGB;
 
 
                 hTmpDC = CreateCompatibleDC (hdcPic);
                 hTmpBmp = CreateDIBSection(hTmpDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
                 SelectObject( hTmpDC, hTmpBmp);
                 BitBlt (hTmpDC, 0, 0, 640, 480, hdcPic, 0, 0, SRCCOPY); //copy picture into bitmap 

//Create a DC for the picture send progress bar (a line that draws horizontally and is not deleted)
			     bmiMarker.bmiHeader.biSize        = sizeof(bmiMarker.bmiHeader);
                 bmiMarker.bmiHeader.biWidth       = 10;
                 bmiMarker.bmiHeader.biHeight      = 480;
                 bmiMarker.bmiHeader.biPlanes      = 1;
                 bmiMarker.bmiHeader.biBitCount    = 32;
                 bmiMarker.bmiHeader.biCompression = BI_RGB;

                 hMarkerDC = CreateCompatibleDC (hdcPic);
                 hMarkerBmp = CreateDIBSection(hMarkerDC, &bmi, DIB_RGB_COLORS,0,0,0);
                 SelectObject( hMarkerDC, hMarkerBmp); 
                 SetForegroundWindow(hwndDlg);     
             } break;

		    }
            break;

 
    case WM_PAINT:

 //Update the send picture 
 
		 BitBlt (hdcPic, 0, 0, 640, 480, hTmpDC, 0, 0, SRCCOPY); //copy bitmap back onto screen 
	return 0;

 
        case WM_CLOSE:
            TXwindowOpen = FALSE;
            Image_mode   = FALSE;
            DeleteObject(hMarkerBmp);
            DeleteDC(hTmpDC);
            KillTimer(hwndDlg,0); 

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}



//============================================================================================
// Send picture load window and various functions, for remote transmission of a file
//============================================================================================
extern LRESULT CALLBACK IMAGE_REMOTE_TX_DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 
 static BITMAPINFO bmi, bmiMarker;
 static HBITMAP    hMarkerBmp;
 static HDC        hTmpDC;
  
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
	   //make sure we do not open more than one instance of the window	   
                TXwindowOpen = TRUE;
                Image_mode   = FALSE;
			    IsImageLoaded   = FALSE;
       //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOP, 10, 10, 0, 0,SWP_SHOWWINDOW | SWP_NOSIZE);     
 
       //Window message to tell users to left click to load image file 
			/*    DeleteObject(hBitmapLeftClickMessage);  //get rid of the old one to avoid GDI leaks
                hBitmapLeftClickMessage = LoadBitmap(g_hInst, "IMG_BITMAP_LEFT_CLICK");  
                SendMessage(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW) ,STM_SETIMAGE, 0,(LPARAM)hBitmapLeftClickMessage); 
*/
				tpicW = 640; tpicH = 480;
 
		//Set a timer going to put image on the screen (needs to be "activated" for some reason
				SetTimer(hwndDlg,1,1000,NULL);

			}
			break;


         case WM_TIMER:
            switch (wParam)
             {

			  case 0:    if(line_counter < pic_decimate+1)  //close everything down when the picture has been sent. "line_counter" counts down from 240 in the send audio callback
                             {
                              TXwindowOpen = FALSE;
                              Image_mode   = FALSE;
                              DeleteObject(hMarkerBmp);
                              DeleteDC(hTmpDC);
                              DeleteDC(hMarkerDC);
			                  DeleteDC(hdcPic);
                                     
                              EndDialog(hwndDlg, 0);
                              DestroyWindow(hwndDlg);		
					         }break;

			case 1:
           {
      
       		wchar_t path_plus_filenameW[255];
			char path_with_filename[255];

		//Append the secure path to the filename, as that is the only folder where files can be requested
			sprintf(path_with_filename,"%s\\%s",full_image_path,&filename[2]); //add the path to "Shared/Images" folder 

         	mbstowcs(path_plus_filenameW, path_with_filename, 80);  //convert the char string filename into a wide string for the routines below

            img = LoadThisImge(path_plus_filenameW);	
	
            HDC hdc=GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));// BeginPaint(hwndPicTX,&ps);
            HDC hdcMem = CreateCompatibleDC (hdc);

            SelectObject(hdcMem,img.hBitmap);   
            SetStretchBltMode(hdc,HALFTONE);        
            StretchBlt(hdc,0,0,640,480, hdcMem,0,0,img.w,img.h,SRCCOPY); 
            DeleteDC(hdcMem);
		    ReleaseDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW),hdc);		
            IsImageLoaded = TRUE;

            DeleteDC(hdc);
            DeleteDC(hTmpDC);                   //Get rid of old objects before loading a new picture
            DeleteObject(hTmpBmp);
            DeleteDC(hMarkerDC);                  
            DeleteObject(hMarkerBmp);	
            DeleteDC(hdcPic);

                                   //Set up a fresh bitmap for the new picture
             hdcPic = GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));           

			 bmi.bmiHeader.biSize        = sizeof(bmi.bmiHeader);
             bmi.bmiHeader.biWidth       = 640;
             bmi.bmiHeader.biHeight      = 480+2;  //make this one larger than the picture (480)
             bmi.bmiHeader.biPlanes      = 1;
             bmi.bmiHeader.biBitCount    = 32;
             bmi.bmiHeader.biCompression = BI_RGB;

 
             hTmpDC = CreateCompatibleDC (hdcPic);
             hTmpBmp = CreateDIBSection(hTmpDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hTmpDC, hTmpBmp);
             BitBlt (hTmpDC, 0, 0, 640, 480, hdcPic, 0, 0, SRCCOPY); //copy picture into bitmap 

//Create a DC for the picture send progress bar (a line that draws horizontally and is not deleted)
			 bmiMarker.bmiHeader.biSize        = sizeof(bmiMarker.bmiHeader);
             bmiMarker.bmiHeader.biWidth       = 10;
             bmiMarker.bmiHeader.biHeight      = 480;
             bmiMarker.bmiHeader.biPlanes      = 1;
             bmiMarker.bmiHeader.biBitCount    = 32;
             bmiMarker.bmiHeader.biCompression = BI_RGB;

             hMarkerDC = CreateCompatibleDC (hdcPic);
             hMarkerBmp = CreateDIBSection(hMarkerDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hMarkerDC, hMarkerBmp); 
             SetForegroundWindow(hwndDlg);
 
			 KillTimer (hwndDlg, 1);

			SendMessage(hwndDlg, WM_COMMAND,IDC_SEND_PIC_BUTTON,0);
			SetTimer(hwnd, 1, 1000, NULL);   //Start a timer and then TX after squelch has closed  
             break;   
           }

             }
             break;  


		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
   
             case IDC_SEND_PIC_BUTTON:
			  {				
			   if(IsImageLoaded == TRUE)  //If there is a picture from file
				{
	             
				 SetTimer(hwndDlg,0,100,NULL);//Start a watchdog timer to check whether the frame has been sent, and close down the webcam window, ready for a new one
				 Image_mode = TRUE;

				 SendMessage(g_hwndTXbutton,WM_LBUTTONDOWN,0,0);     //DON'T use PostMessage as the window will lose focus and not return
				 line_counter = 480;
				 PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);             //clear the picture send progress bar
			    }
			   else
				{
				 Image_mode = FALSE;             //If not sending a picture at all!
				}
			    SetForegroundWindow(hwndDlg);	 //This ensures focus is set back to the TX pic window	
		      }          
              break;
		    }
            break;

 
    case WM_PAINT:

 //Update the send picture 
 
		 BitBlt (hdcPic, 0, 0, 640, 480, hTmpDC, 0, 0, SRCCOPY); //copy bitmap back onto screen 
	return 0;

 
        case WM_CLOSE:
            TXwindowOpen = FALSE;
            Image_mode   = FALSE;
            DeleteObject(hMarkerBmp);
            DeleteDC(hTmpDC);
            KillTimer(hwndDlg,0); 

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}



//============================================================================================
// Webcam window and various functions (OLD CODE NOW SUPERSEDED BY DIRECTSHOW VERSION)
//============================================================================================
extern LRESULT CALLBACK WEBCAM_TX_DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 
 static BITMAPINFO bmi, bmiMarker;
 static HBITMAP    hMarkerBmp;
 static HDC        hTmpDC;
  
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
	   //make sure we do not open more than one instance of the window	   
                TXwindowOpen = TRUE;

       //make sure the window stays on top as SetForegroundWindow does not appear to work in this instance (now it does!)
                SetWindowPos (hwndDlg, HWND_TOPMOST, 10, 10, 0, 0,SWP_SHOWWINDOW | SWP_NOSIZE);   

       //default is Webcam can send pic, but this can change depending upon user preference for duration of program                              
                 if(Webcam == TRUE) SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_SETCHECK,1,0);
                 if(Webcam == FALSE)SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_SETCHECK,0,0);
 
       //default is large pic
			if(Remote_webcam == FALSE)
			    {
                 LARGE_PIC = TRUE;
                 SMALL_PIC = FALSE;
                 FAX       = FALSE;   
			     tpicW = 640; tpicH = 480;
                 SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC), BM_SETCHECK,0,0);
                 SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC), BM_SETCHECK,1,0);
                }
                  IsImageLoaded = FALSE;  //We are not using a file picture (do I need this here?)
      //Get rid of old objects before grabbing a new frame from the camera
                  DeleteDC(hTmpDC);      
                  DeleteObject(hTmpBmp);
                  DeleteDC(hMarkerDC);                  
                  DeleteObject(hMarkerBmp);
                  DeleteDC(hdcPic);	

      //Webcam code
                 hwndWebcam = capCreateCaptureWindow (NULL, WS_CHILD | WS_VISIBLE , 0, 0, 640,480,GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW),0);
                 ShowWindow(hwndWebcam,SW_SHOW);
            //     SendMessage(hwndWebcam,WM_CAP_DRIVER_CONNECT,0,0);
                 capDriverConnect (hwndWebcam, 0);         
			     capDriverConnect (hwndWebcam, 0);       // start it twice to avoid crashes etc...but why is this needed?
	             capPreview       (hwndWebcam, TRUE);    // start preview 
	             capPreviewRate   (hwndWebcam, 200);     // rate, in milliseconds, the frame rate here is just for preview window, not for capturing
	             capPreviewScale  (hwndWebcam, TRUE);

                 if(Remote_webcam == TRUE)SetTimer(hwndDlg,0,2000,NULL); //Start a 2 second timer to give the webcam a chance to get setup before we press the send button remotely
		
			}
			break;


         case WM_TIMER:
            switch (wParam)
             {
			  case 0:    SendMessage(hwndDlg, WM_COMMAND,IDC_SEND_PIC_BUTTON,0);break;  //This will start sending after 1 second

			  case 1:    if(line_counter < pic_decimate+1)  //close everything down when the picture has been sent. "line_counter" counts down from 240 in the send audio callback
                             {
                              TXwindowOpen  = FALSE;
                              Image_mode    = FALSE;
						      Remote_webcam = FALSE;

                              ReleaseDC(hwndWebcamTX,hdcPic);	  
                              SendMessage(hwndWebcam, WM_CAP_DRIVER_DISCONNECT, 0, 0);	
	                          capPreview(hwndWebcam, FALSE);     
                              capDriverDisconnect(hwndWebcam);
                              DeleteObject(hMarkerBmp);
                              DeleteDC(hTmpDC);
                              DeleteDC(hMarkerDC);
			                  DeleteDC(hdcPic);
                              Sleep(500);
                              DestroyWindow(hwndWebcam);
                              EndDialog(hwndDlg, 0);
                              DestroyWindow(hwndDlg);			
					         }break;
             }
           break;  

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
   
             case IDC_SEND_PIC_BUTTON:
			  {			
	              KillTimer(hwndDlg,0);  //Close down the "start" timer once the send is in progress
				  SetTimer(hwndDlg,1,100,NULL);//Start a watchdog timer to check whether the frame has been sent, and close down the webcam window, ready for a new one
                  if(Webcam == FALSE)break;//do not send unless allowed
			    //Get rid of old objects before grabbing a new frame from the camera
                  DeleteDC(hTmpDC);      
                  DeleteObject(hTmpBmp);
                  DeleteDC(hMarkerDC);                  
                  DeleteObject(hMarkerBmp);
                  DeleteDC(hdcPic);	

                //Grab a Frame
                  SendMessage(hwndWebcam, WM_CAP_GRAB_FRAME, 0, 0);
                //Copy the frame we have just grabbed to the clipboard
                  SendMessage(hwndWebcam, WM_CAP_EDIT_COPY,0,0);

                //Copy the clipboard image data to a HBITMAP object called hTmpBmp           
                  if (OpenClipboard(hwndWebcam))
                  {
                    hTmpBmp = (HBITMAP) GetClipboardData(CF_BITMAP);
                    CloseClipboard();
                  }

           //Set up a fresh bitmap for the camera
             hdcPic = GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));           

			 bmi.bmiHeader.biSize        = sizeof(bmi.bmiHeader);
             bmi.bmiHeader.biWidth       = 640;
             bmi.bmiHeader.biHeight      = 480+2;  //make this one larger than the picture (240) else crash!
             bmi.bmiHeader.biPlanes      = 1;
             bmi.bmiHeader.biBitCount    = 32;
             bmi.bmiHeader.biCompression = BI_RGB;

 
             hTmpDC = CreateCompatibleDC (hdcPic);
             hTmpBmp = CreateDIBSection(hTmpDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hTmpDC, hTmpBmp);
             BitBlt (hTmpDC, 0, 0, 640, 480, hdcPic, 0, 0, SRCCOPY); //copy picture into bitmap 

       //Create a DC for the picture send progress bar (a line that draws horizontally and is not deleted)
			 bmiMarker.bmiHeader.biSize        = sizeof(bmiMarker.bmiHeader);
             bmiMarker.bmiHeader.biWidth       = 10;
             bmiMarker.bmiHeader.biHeight      = 480;
             bmiMarker.bmiHeader.biPlanes      = 1;
             bmiMarker.bmiHeader.biBitCount    = 32;
             bmiMarker.bmiHeader.biCompression = BI_RGB;

             hMarkerDC = CreateCompatibleDC (hdcPic);
             hMarkerBmp = CreateDIBSection(hMarkerDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hMarkerDC, hMarkerBmp); 
    

				 Image_mode = TRUE;
                 int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
		         if(LARGE_PIC==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" L"); //don't forget the space after the direction call
		         if(SMALL_PIC==TRUE)SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" S");
				 SendMessage(g_hwndTXbutton,WM_LBUTTONDOWN,0,0);     //MUST use SendMessage instead of PostMessage otherwise SetForegroundWindow is too early
				 line_counter = 480;                                 //We start line count from 240 rather than up from 0 as Windoze images are upside down!
				 PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);             //Clear the picture send progress bar               

			    SetForegroundWindow(hwndDlg);	 
		      } 			 
              break;

           case IDC_VIDEO_SOURCE:
                 capDlgVideoSource(hwndWebcam);
              break;

           case IDC_VIDEO_FORMAT:
                 capDlgVideoFormat(hwndWebcam);           
              break;

           case IDC_SMALL_PIC:
			   {
                LARGE_PIC = FALSE;
                SMALL_PIC = TRUE;
                FAX       = FALSE;   
				tpicH = 480; tpicW = 640;         //It is always 320x240 for send pic 
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC), BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC), BM_SETCHECK,0,0);
			   }
			    break;

           case IDC_LARGE_PIC:
		   	   {
                LARGE_PIC = TRUE;
                SMALL_PIC = FALSE;
                FAX       = FALSE;   
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC), BM_SETCHECK,1,0);
		   	   }
                break;

           case IDC_WEBCAM_ON:
				{
                 if(SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_GETCHECK, 0, 0)==1)Webcam = TRUE;
				 if(SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_GETCHECK, 0, 0)==0)Webcam = FALSE;
				}
				 break;
		    }
            break;


    case WM_PAINT:

 //Update the send picture (this is a bit unstable in the subclass procedure (uses more cpu than if in subclass procedure) - now redundant comment
 
	//	 BitBlt (hdcPic, 0, 0, 640, 480, hTmpDC, 0, 0, SRCCOPY); //copy bitmap back onto screen 
	return 0;

 
        case WM_CLOSE:
            TXwindowOpen = FALSE;
            Image_mode   = FALSE;
			Remote_webcam = FALSE;

            ReleaseDC(hwndWebcamTX,hdcPic);	  
            SendMessage(hwndWebcam, WM_CAP_DRIVER_DISCONNECT, 0, 0);
	
	        capPreview(hwndWebcam, FALSE);     // stop preview 
            capDriverDisconnect(hwndWebcam);
            DeleteObject(hMarkerBmp);
            DeleteDC(hTmpDC);
            DeleteDC(hMarkerDC);
			DeleteDC(hdcPic);
            Sleep(500);
            DestroyWindow(hwndWebcam);
            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}

//===========================================================================================
// Receive image display and processing
//===========================================================================================
static LRESULT CALLBACK IMAGE_RX_DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

 static HDC         hDisplay;
 static HDC         hTmpDCRX;
 static BITMAPINFO  bmiRX;
 static HBITMAP     hTmpBmpRX;
 static int         slant_range = 10;
 static	int         p,l;

    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    hDisplay     = GetDC(GetDlgItem(hwndDlg,ID_PIC_RX_WINDOW));        //A DC for use in displaying pixels
                SetStretchBltMode(hDisplay, HALFTONE);                             //Smooths interpolated pixels 

                DeleteDC(hTmpDCRX);      //Get rid of old objects
                DeleteObject(hTmpBmpRX);

		if(VERYLARGE_PIC == TRUE) {picW=640;picH=480;}
			else
		if(LARGE_PIC     == TRUE) {picW=320;picH=240;}
			else
		if(SMALL_PIC     == TRUE) {picW=160;picH=120;}
			else
		if(FAX           == TRUE) {picW=640;picH=480;}
	
		

               //make sure the window stays on top? No.
             //   SetWindowPos (hwndDlg, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   		        SetWindowPos (hwndDlg, HWND_TOP, 10, 300, 0, 0,SWP_SHOWWINDOW | SWP_NOSIZE);   
 
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject( hTmpDCRX, hTmpBmpRX);

                          PatBlt(hDisplay,0,0,640,480,BLACKNESS);  //Clear the screen
                          memset(pix_display,0,640*482*4);
                          line = 0;
                   

             pic_phase = 0;
			 pic_skew  = 0;
             SetTimer(hwndDlg,0,100,NULL);  //A timer to update the picture 10 times a sec so that pic corrections are smooth


			}
			break;

     case WM_TIMER:

			StretchDIBits(hDisplay,0,0,640,480,0,0,picW,picH,&pix_display, &bmiRX, DIB_RGB_COLORS,SRCCOPY);
		
		    break;	


    case WM_CONTEXTMENU:
//Now see if we have a right-click on the image receive screen
 			{
 //Example to Save Screen in File
         wchar_t fileName[MAX_PATH]=L"\x0000";

           OPENFILENAMEW ofn;
           ZeroMemory(&ofn, sizeof(ofn));
           ofn.lStructSize = sizeof(ofn);
           ofn.hwndOwner = hwnd;
           ofn.lpstrFilter =
                    L"JPG (*.jpg)"
                    L"\0*.jpg\0\0";
           ofn.lpstrFile = fileName;
           ofn.nMaxFile = MAX_PATH;
           ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

                            
      if(GetSaveFileNameW(&ofn))
             {
               ULONG_PTR gdiplusToken;

            // INIT GDI+
               GdiplusStartup(&gdiplusToken, &g_GdiplusStartupInput, NULL);

               CLSID encoderClsid;
               GetEncoderClsid(L"image/jpeg", &encoderClsid);

               ENCODERPARAMETERS encoderParameters;
               ULONG quality;
               HDC hDCSrc, hDCMemory;
               HBITMAP hBmp, hBmpPrev;
               long t;

         // COPY SCREEN TO BITMAP

               hDCSrc = GetDC(GetDlgItem(hwndDlg,ID_PIC_RX_WINDOW));   
               hDCMemory = CreateCompatibleDC(hDCSrc);
               hBmp = CreateCompatibleBitmap(hDCSrc, picW,picH);
               hBmpPrev = SelectObject(hDCMemory, hBmp);


			   SetDIBitsToDevice(hDCMemory,0,0,picW,picH,0,0,0,picH,&pix_display, &bmiRX, DIB_RGB_COLORS);  //copy the original 320x240, not the larger version
               hBmp = SelectObject(hDCMemory, hBmpPrev);
               DeleteObject(hBmpPrev);
               DeleteDC(hDCMemory);


          // COPY BITMAP TO GDI+ BITMAP
               GdipCreateBitmapFromHBITMAP(hBmp, 0,  (GP_GPBITMAP** ) &t);
               DeleteObject (hBmp);
   
               encoderParameters.Count = 1;
               encoderParameters.Parameter[0].Guid = EncoderQuality;
               encoderParameters.Parameter[0].Type = eEncoderParameterValueTypeLong;
               encoderParameters.Parameter[0].NumberOfValues = 1;

         // Save the image as a JPEG with quality level 100.
               quality = 100;
               encoderParameters.Parameter[0].Value = &quality;

         // CREATE FILE NAME 
         //Append jpg to wide character filename. Note we must cast the ".jpg" into a wide character as well	  
               wcscat(fileName, (wchar_t *)L".jpg"); 


        // SAVE IMAGE TO FILE

               GdipSaveImageToFile( (GP_GPIMAGE *) t,  fileName, &encoderClsid, &encoderParameters);
        // CLOSE GDI+.
               GdipDisposeImage ( (GP_GPIMAGE *) t );
               GdiplusShutdown(gdiplusToken);
			   DeleteObject(hBmpPrev);
             }
			}
             return 0;

 


		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
             case IDC_PIC_START_VERYLARGE:
			   {
				 FAX           = FALSE;
                 SMALL_PIC     = FALSE;
				 LARGE_PIC     = FALSE;
				 VERYLARGE_PIC = TRUE;
                 DeleteDC(hTmpDCRX);      //Get rid of old objects
                 DeleteObject(hTmpBmpRX);
   		         picH = 480; picW = 640;
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject(hTmpDCRX, hTmpBmpRX);


                 if(PicStart == FALSE)
					{
				     PicStart = TRUE;
					}
					else
					{
                     PicStart = FALSE;
					}
	             line = 0;	
			   }
                break; 



             case IDC_PIC_START:
			   {
				 FAX           = FALSE;
                 SMALL_PIC     = FALSE;
				 LARGE_PIC     = TRUE;
				 VERYLARGE_PIC = FALSE;
                 DeleteDC(hTmpDCRX);      //Get rid of old objects
                 DeleteObject(hTmpBmpRX);
   		         picH = 240; picW = 320;
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject(hTmpDCRX, hTmpBmpRX);

                 if(PicStart == FALSE)
					{
				     PicStart = TRUE;
					}
					else
					{
                     PicStart = FALSE;
					}
	             line = 0;	
			   }
                break; 




             case IDC_PIC_START_SMALL:
			   {
				  FAX = FALSE;
                  SMALL_PIC = TRUE;
				  LARGE_PIC = FALSE;
                  DeleteDC(hTmpDCRX);      //Get rid of old objects  
                  DeleteObject(hTmpBmpRX);
                  picH = 120; picW = 160;
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject(hTmpDCRX, hTmpBmpRX);

                 if(PicStart == FALSE)
					{
				     PicStart = TRUE;
					}
					else
					{
                     PicStart = FALSE;
					}
	             line = 0;	
			   }
                break; 

             case IDC_PIC_START_WEFAX:
			   {

                  DeleteDC(hTmpDCRX);      //Get rid of old objects  
                  DeleteObject(hTmpBmpRX);
                  picH = 400; picW = 600;
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject(hTmpDCRX, hTmpBmpRX);

                 if(PicStart == FALSE)
					{
				     PicStart = TRUE;
					}
					else
					{
                     PicStart = FALSE;
					}
	             line = 0;	
			   }
                break; 



             case IDC_PIC_START_FAX:
			   {
				  FAX       = TRUE;
                  SMALL_PIC = FALSE;
				  LARGE_PIC = FALSE;

                  DeleteDC(hTmpDCRX);      //Get rid of old objects  
                  DeleteObject(hTmpBmpRX);
                  picH = 480; picW = 640;
                          bmiRX.bmiHeader.biSize        = sizeof(bmiRX.bmiHeader);
                          bmiRX.bmiHeader.biWidth       = picW;
                          bmiRX.bmiHeader.biHeight      = -picH;
                          bmiRX.bmiHeader.biPlanes      = 1;
                          bmiRX.bmiHeader.biBitCount    = 32;   //display buffer is DWORD
                          bmiRX.bmiHeader.biCompression = BI_RGB;

 
                          hTmpDCRX = CreateCompatibleDC (hDisplay);
                          hTmpBmpRX = CreateDIBSection(hTmpDCRX, &bmiRX, DIB_RGB_COLORS,0, 0, 0);
                          SelectObject(hTmpDCRX, hTmpBmpRX);

                 if(PicStart == FALSE)
					{
				     PicStart = TRUE;
					}
					else
					{
                     PicStart = FALSE;
					}
	             line = 0;	
			   }
                break;


 
//This is a terrible way to handle case statements, but it works! Couldn't get an external function to work.
case IDC_PHASE_LEFT_100: pic_phase+=100;goto process;     
case IDC_PHASE_LEFT_10:	 pic_phase+=10; goto process;					
case IDC_PHASE_LEFT_1:   pic_phase+=1;  goto process;
case IDC_PHASE_RIGHT_1:  pic_phase-=1;  goto process;
case IDC_PHASE_RIGHT_10: pic_phase-=10; goto process;
case IDC_PHASE_RIGHT_100:pic_phase-=100;goto process;

case IDC_SLANT_LEFT_100: pic_skew+=100;goto process;     
case IDC_SLANT_LEFT_10:	 pic_skew+=10; goto process;					
case IDC_SLANT_LEFT_1:   pic_skew+=1;  goto process;
case IDC_SLANT_RIGHT_1:  pic_skew-=1;  goto process;
case IDC_SLANT_RIGHT_10: pic_skew-=10; goto process;
case IDC_SLANT_RIGHT_100:pic_skew-=100;goto process;


process:

//============== Process picture phase and slant ===================================================================================================     
             
if(FAX == TRUE)goto process_fax;
//Adjust picture phasing by shuffling the samples along  -  10 samples/pixel and 3 lots of pixels for each of R,G, and B = *30
        for(p=0;p<picW*picH*30;p++)     
	       {
            pix_processed_skew[p/2] = pix_processed[p + pic_phase*10]; 
	       }
//And now adjust picture slant/skew (we have 10 samples per pixel, hence the 10 times numbers)
for (l=0;l<picH;l++)
   {
    for(p=0;p<picW*300;p++)     //stretch the buffer 20x to allow fine adjustment of picture slant/skew
	   {
        pix_processed_extended[p-picW*300]      = pix_processed_skew[p/20 + picW*15*(l-1)];   // <---Careful!! negative lines!
        pix_processed_extended[p]               = pix_processed_skew[p/20 + picW*15* l   ];
        pix_processed_extended[p+picW*300]      = pix_processed_skew[p/20 + picW*15*(l+1)];
 
	   }
     
    for(p=0;p<picW*100;p++)       //adjust each line by the right amount
	   {
        pix_display[p/100 + picW*l] =   pix_processed_extended[p            + pic_skew*l]            //convert the 3 lines into colour
								      + pix_processed_extended[p + picW*100 + pic_skew*l] * 256
								      + pix_processed_extended[p + picW*200 + pic_skew*l] * 256*256;
	   }
   }
return 0;
process_fax:
//Adjust picture phasing by shuffling the samples along  -  10 samples/pixel and 3 lots of pixels for each of R,G, and B = *30
        for(p=0;p<picW*picH*10;p++)     
	       {
            pix_processed_skew[p/2] = pix_processed[p + pic_phase*10]; 
	       }
//And now adjust picture slant/skew (we have 10 samples per pixel, hence the 10 times numbers)
for (l=0;l<picH;l++)
   {
    for(p=0;p<picW*100;p++)     //stretch the buffer 20x to allow fine adjustment of picture slant/skew
	   {
        pix_processed_extended[p-picW*100]      = pix_processed_skew[p/20 + picW*5*(l-1)];   // <---Careful!! negative lines!
        pix_processed_extended[p]               = pix_processed_skew[p/20 + picW*5* l   ];
        pix_processed_extended[p+picW*100]      = pix_processed_skew[p/20 + picW*5*(l+1)];

 
	   }
     
    for(p=0;p<picW*100;p++)       //adjust each line by the right amount
	   {
        pix_display[p/100 + picW*l] =   pix_processed_extended[p + pic_skew*l]*(1+256+256*256);            //convert the 3 lines into colour
								   
	   }
   }

   return 0;
//=====================================================================================================================================================



             case IDC_SAVE_PIC:
 			{
 //Example to Save Screen in File
         wchar_t fileName[MAX_PATH]=L"\x0000";

           OPENFILENAMEW ofn;
           ZeroMemory(&ofn, sizeof(ofn));
           ofn.lStructSize = sizeof(ofn);
           ofn.hwndOwner = hwnd;
           ofn.lpstrFilter =
                    L"JPG (*.jpg)"
                    L"\0*.jpg\0\0";
           ofn.lpstrFile = fileName;
           ofn.nMaxFile = MAX_PATH;
           ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

                            
      if(GetSaveFileNameW(&ofn))
             {
               ULONG_PTR gdiplusToken;

            // INIT GDI+
               GdiplusStartup(&gdiplusToken, &g_GdiplusStartupInput, NULL);

               CLSID encoderClsid;
               GetEncoderClsid(L"image/jpeg", &encoderClsid);

               ENCODERPARAMETERS encoderParameters;
               ULONG quality;
               HDC hDCSrc, hDCMemory;
               HBITMAP hBmp, hBmpPrev;
               long t;

         // COPY SCREEN TO BITMAP

               hDCSrc = GetDC(GetDlgItem(hwndDlg,ID_PIC_RX_WINDOW));   
               hDCMemory = CreateCompatibleDC(hDCSrc);
               hBmp = CreateCompatibleBitmap(hDCSrc, picW,picH);
               hBmpPrev = SelectObject(hDCMemory, hBmp);


			   SetDIBitsToDevice(hDCMemory,0,0,picW,picH,0,0,0,picH,&pix_display, &bmiRX, DIB_RGB_COLORS);  //copy the original 320x240, not the larger version
               hBmp = SelectObject(hDCMemory, hBmpPrev);
               DeleteObject(hBmpPrev);
               DeleteDC(hDCMemory);


          // COPY BITMAP TO GDI+ BITMAP
               GdipCreateBitmapFromHBITMAP(hBmp, 0,  (GP_GPBITMAP** ) &t);
               DeleteObject (hBmp);
   
               encoderParameters.Count = 1;
               encoderParameters.Parameter[0].Guid = EncoderQuality;
               encoderParameters.Parameter[0].Type = eEncoderParameterValueTypeLong;
               encoderParameters.Parameter[0].NumberOfValues = 1;

         // Save the image as a JPEG with quality level 100.
               quality = 100;
               encoderParameters.Parameter[0].Value = &quality;

         // CREATE FILE NAME 
         //Append jpg to wide character filename. Note we must cast the ".jpg" into a wide character as well	  
               wcscat(fileName, (wchar_t *)L".jpg"); 


        // SAVE IMAGE TO FILE

               GdipSaveImageToFile( (GP_GPIMAGE *) t,  fileName, &encoderClsid, &encoderParameters);
        // CLOSE GDI+.
               GdipDisposeImage ( (GP_GPIMAGE *) t );
               GdiplusShutdown(gdiplusToken);
			   DeleteObject(hBmpPrev);
             }
			}
             break;
			
		    }
            break;




      case WM_PAINT:
         StretchDIBits(hDisplay,0,0,640,480,0,0,picW,picH,&pix_display, &bmiRX, DIB_RGB_COLORS,SRCCOPY	); 
		 break;	



        case WM_CLOSE:
         //   LARGE_PIC = TRUE;        //set back to large pic in case we stopped with some other mode
            DeleteDC(hTmpDCRX);      //Get rid of old objects
            DeleteDC(hDisplay);                
            DeleteObject(hTmpBmpRX);
            memset(pix_display,0,640*482*4); //Clear the whole pic buffer
			KillTimer(hwndDlg,0);  
            EndDialog(hwndDlg, 0);	
	
            return TRUE;
		 }

    return FALSE;
}






//=======================================================================================
//=====================  Picture demodulating functions =================================
//=======================================================================================

void do_nco_step(void)
{
	nco_ang += 2*3.14159*(1145+channel_offset)/FS; //1145Hz is the centre frequency
	if (nco_ang >= two_pi) nco_ang -= two_pi;
}

void make_I_and_Q(double dat)
{
	int i;
	for (i=0;i<257;i++) 
	{
		I_bu[i] = I_bu[i+1];
		Q_bu[i] = Q_bu[i+1];
	}
	I_bu[256] = dat * sin(nco_ang);
	Q_bu[256] = dat * cos(nco_ang);
}

/*Tap=256 LPF fs=11025.0[Hz] fc=500.0[Hz] 60.0[dB] Gain=1.0*/
float LPF_old[257]={
	-4.770475e-05,	/*H[0]=H[256]*/
	-5.754926e-05,	/*H[1]=H[255]*/
	-6.344600e-05,	/*H[2]=H[254]*/
	-6.372239e-05,	/*H[3]=H[253]*/
	-5.704556e-05,	/*H[4]=H[252]*/
	-4.264050e-05,	/*H[5]=H[251]*/
	-2.047689e-05,	/*H[6]=H[250]*/
	8.601209e-06,	/*H[7]=H[249]*/
	4.282523e-05,	/*H[8]=H[248]*/
	7.954815e-05,	/*H[9]=H[247]*/
	1.153945e-04,	/*H[10]=H[246]*/
	1.465118e-04,	/*H[11]=H[245]*/
	1.689094e-04,	/*H[12]=H[244]*/
	1.788606e-04,	/*H[13]=H[243]*/
	1.733313e-04,	/*H[14]=H[242]*/
	1.503960e-04,	/*H[15]=H[241]*/
	1.095933e-04,	/*H[16]=H[240]*/
	5.217813e-05,	/*H[17]=H[239]*/
	-1.876897e-05,	/*H[18]=H[238]*/
	-9.840435e-05,	/*H[19]=H[237]*/
	-1.803691e-04,	/*H[20]=H[236]*/
	-2.572197e-04,	/*H[21]=H[235]*/
	-3.210201e-04,	/*H[22]=H[234]*/
	-3.640535e-04,	/*H[23]=H[233]*/
	-3.795983e-04,	/*H[24]=H[232]*/
	-3.626970e-04,	/*H[25]=H[231]*/
	-3.108444e-04,	/*H[26]=H[230]*/
	-2.245151e-04,	/*H[27]=H[229]*/
	-1.074653e-04,	/*H[28]=H[228]*/
	3.324734e-05,	/*H[29]=H[227]*/
	1.875562e-04,	/*H[30]=H[226]*/
	3.429959e-04,	/*H[31]=H[225]*/
	4.856045e-04,	/*H[32]=H[224]*/
	6.010622e-04,	/*H[33]=H[223]*/
	6.759813e-04,	/*H[34]=H[222]*/
	6.992420e-04,	/*H[35]=H[221]*/
	6.632529e-04,	/*H[36]=H[220]*/
	5.650086e-04,	/*H[37]=H[219]*/
	4.068290e-04,	/*H[38]=H[218]*/
	1.966780e-04,	/*H[39]=H[217]*/
	-5.200508e-05,	/*H[40]=H[216]*/
	-3.209938e-04,	/*H[41]=H[215]*/
	-5.884650e-04,	/*H[42]=H[214]*/
	-8.306289e-04,	/*H[43]=H[213]*/
	-1.023689e-03,	/*H[44]=H[212]*/
	-1.145982e-03,	/*H[45]=H[211]*/
	-1.180116e-03,	/*H[46]=H[210]*/
	-1.114921e-03,	/*H[47]=H[209]*/
	-9.470006e-04,	/*H[48]=H[208]*/
	-6.817333e-04,	/*H[49]=H[207]*/
	-3.335651e-04,	/*H[50]=H[206]*/
	7.448042e-05,	/*H[51]=H[205]*/
	5.121005e-04,	/*H[52]=H[204]*/
	9.437702e-04,	/*H[53]=H[203]*/
	1.331436e-03,	/*H[54]=H[202]*/
	1.637658e-03,	/*H[55]=H[201]*/
	1.828954e-03,	/*H[56]=H[200]*/
	1.879074e-03,	/*H[57]=H[199]*/
	1.771890e-03,	/*H[58]=H[198]*/
	1.503638e-03,	/*H[59]=H[197]*/
	1.084249e-03,	/*H[60]=H[196]*/
	5.375753e-04,	/*H[61]=H[195]*/
	-9.957186e-05,	/*H[62]=H[194]*/
	-7.796015e-04,	/*H[63]=H[193]*/
	-1.447429e-03,	/*H[64]=H[192]*/
	-2.044671e-03,	/*H[65]=H[191]*/
	-2.514442e-03,	/*H[66]=H[190]*/
	-2.806395e-03,	/*H[67]=H[189]*/
	-2.881574e-03,	/*H[68]=H[188]*/
	-2.716640e-03,	/*H[69]=H[187]*/
	-2.307078e-03,	/*H[70]=H[186]*/
	-1.669009e-03,	/*H[71]=H[185]*/
	-8.393653e-04,	/*H[72]=H[184]*/
	1.257074e-04,	/*H[73]=H[183]*/
	1.154217e-03,	/*H[74]=H[182]*/
	2.163292e-03,	/*H[75]=H[181]*/
	3.065446e-03,	/*H[76]=H[180]*/
	3.775689e-03,	/*H[77]=H[179]*/
	4.218943e-03,	/*H[78]=H[178]*/
	4.337165e-03,	/*H[79]=H[177]*/
	4.095529e-03,	/*H[80]=H[176]*/
	3.487098e-03,	/*H[81]=H[175]*/
	2.535487e-03,	/*H[82]=H[174]*/
	1.295135e-03,	/*H[83]=H[173]*/
	-1.509889e-04,	/*H[84]=H[172]*/
	-1.696233e-03,	/*H[85]=H[171]*/
	-3.217446e-03,	/*H[86]=H[170]*/
	-4.584055e-03,	/*H[87]=H[169]*/
	-5.668419e-03,	/*H[88]=H[168]*/
	-6.356691e-03,	/*H[89]=H[167]*/
	-6.559336e-03,	/*H[90]=H[166]*/
	-6.220409e-03,	/*H[91]=H[165]*/
	-5.324765e-03,	/*H[92]=H[164]*/
	-3.902452e-03,	/*H[93]=H[163]*/
	-2.029764e-03,	/*H[94]=H[162]*/
	1.733941e-04,	/*H[95]=H[161]*/
	2.549841e-03,	/*H[96]=H[160]*/
	4.914928e-03,	/*H[97]=H[159]*/
	7.069277e-03,	/*H[98]=H[158]*/
	8.813648e-03,	/*H[99]=H[157]*/
	9.964920e-03,	/*H[100]=H[156]*/
	1.037204e-02,	/*H[101]=H[155]*/
	9.930698e-03,	/*H[102]=H[154]*/
	8.595548e-03,	/*H[103]=H[153]*/
	6.388883e-03,	/*H[104]=H[152]*/
	3.404903e-03,	/*H[105]=H[151]*/
	-1.910111e-04,	/*H[106]=H[150]*/
	-4.168263e-03,	/*H[107]=H[149]*/
	-8.242125e-03,	/*H[108]=H[148]*/
	-1.208941e-02,	/*H[109]=H[147]*/
	-1.536789e-02,	/*H[110]=H[146]*/
	-1.773825e-02,	/*H[111]=H[145]*/
	-1.888716e-02,	/*H[112]=H[144]*/
	-1.854997e-02,	/*H[113]=H[143]*/
	-1.653134e-02,	/*H[114]=H[142]*/
	-1.272236e-02,	/*H[115]=H[141]*/
	-7.112845e-03,	/*H[116]=H[140]*/
	2.022708e-04,	/*H[117]=H[139]*/
	9.023016e-03,	/*H[118]=H[138]*/
	1.905123e-02,	/*H[119]=H[137]*/
	2.990387e-02,	/*H[120]=H[136]*/
	4.113220e-02,	/*H[121]=H[135]*/
	5.224557e-02,	/*H[122]=H[134]*/
	6.273859e-02,	/*H[123]=H[133]*/
	7.211976e-02,	/*H[124]=H[132]*/
	7.993995e-02,	/*H[125]=H[131]*/
	8.581867e-02,	/*H[126]=H[130]*/
	8.946667e-02,	/*H[127]=H[129]*/
	9.070317e-02,	/*H[128]=H[128]*/
	8.946667e-02,	/*H[129]=H[127]*/
	8.581867e-02,	/*H[130]=H[126]*/
	7.993995e-02,	/*H[131]=H[125]*/
	7.211976e-02,	/*H[132]=H[124]*/
	6.273859e-02,	/*H[133]=H[123]*/
	5.224557e-02,	/*H[134]=H[122]*/
	4.113220e-02,	/*H[135]=H[121]*/
	2.990387e-02,	/*H[136]=H[120]*/
	1.905123e-02,	/*H[137]=H[119]*/
	9.023016e-03,	/*H[138]=H[118]*/
	2.022708e-04,	/*H[139]=H[117]*/
	-7.112845e-03,	/*H[140]=H[116]*/
	-1.272236e-02,	/*H[141]=H[115]*/
	-1.653134e-02,	/*H[142]=H[114]*/
	-1.854997e-02,	/*H[143]=H[113]*/
	-1.888716e-02,	/*H[144]=H[112]*/
	-1.773825e-02,	/*H[145]=H[111]*/
	-1.536789e-02,	/*H[146]=H[110]*/
	-1.208941e-02,	/*H[147]=H[109]*/
	-8.242125e-03,	/*H[148]=H[108]*/
	-4.168263e-03,	/*H[149]=H[107]*/
	-1.910111e-04,	/*H[150]=H[106]*/
	3.404903e-03,	/*H[151]=H[105]*/
	6.388883e-03,	/*H[152]=H[104]*/
	8.595548e-03,	/*H[153]=H[103]*/
	9.930698e-03,	/*H[154]=H[102]*/
	1.037204e-02,	/*H[155]=H[101]*/
	9.964920e-03,	/*H[156]=H[100]*/
	8.813648e-03,	/*H[157]=H[99]*/
	7.069277e-03,	/*H[158]=H[98]*/
	4.914928e-03,	/*H[159]=H[97]*/
	2.549841e-03,	/*H[160]=H[96]*/
	1.733941e-04,	/*H[161]=H[95]*/
	-2.029764e-03,	/*H[162]=H[94]*/
	-3.902452e-03,	/*H[163]=H[93]*/
	-5.324765e-03,	/*H[164]=H[92]*/
	-6.220409e-03,	/*H[165]=H[91]*/
	-6.559336e-03,	/*H[166]=H[90]*/
	-6.356691e-03,	/*H[167]=H[89]*/
	-5.668419e-03,	/*H[168]=H[88]*/
	-4.584055e-03,	/*H[169]=H[87]*/
	-3.217446e-03,	/*H[170]=H[86]*/
	-1.696233e-03,	/*H[171]=H[85]*/
	-1.509889e-04,	/*H[172]=H[84]*/
	1.295135e-03,	/*H[173]=H[83]*/
	2.535487e-03,	/*H[174]=H[82]*/
	3.487098e-03,	/*H[175]=H[81]*/
	4.095529e-03,	/*H[176]=H[80]*/
	4.337165e-03,	/*H[177]=H[79]*/
	4.218943e-03,	/*H[178]=H[78]*/
	3.775689e-03,	/*H[179]=H[77]*/
	3.065446e-03,	/*H[180]=H[76]*/
	2.163292e-03,	/*H[181]=H[75]*/
	1.154217e-03,	/*H[182]=H[74]*/
	1.257074e-04,	/*H[183]=H[73]*/
	-8.393653e-04,	/*H[184]=H[72]*/
	-1.669009e-03,	/*H[185]=H[71]*/
	-2.307078e-03,	/*H[186]=H[70]*/
	-2.716640e-03,	/*H[187]=H[69]*/
	-2.881574e-03,	/*H[188]=H[68]*/
	-2.806395e-03,	/*H[189]=H[67]*/
	-2.514442e-03,	/*H[190]=H[66]*/
	-2.044671e-03,	/*H[191]=H[65]*/
	-1.447429e-03,	/*H[192]=H[64]*/
	-7.796015e-04,	/*H[193]=H[63]*/
	-9.957186e-05,	/*H[194]=H[62]*/
	5.375753e-04,	/*H[195]=H[61]*/
	1.084249e-03,	/*H[196]=H[60]*/
	1.503638e-03,	/*H[197]=H[59]*/
	1.771890e-03,	/*H[198]=H[58]*/
	1.879074e-03,	/*H[199]=H[57]*/
	1.828954e-03,	/*H[200]=H[56]*/
	1.637658e-03,	/*H[201]=H[55]*/
	1.331436e-03,	/*H[202]=H[54]*/
	9.437702e-04,	/*H[203]=H[53]*/
	5.121005e-04,	/*H[204]=H[52]*/
	7.448042e-05,	/*H[205]=H[51]*/
	-3.335651e-04,	/*H[206]=H[50]*/
	-6.817333e-04,	/*H[207]=H[49]*/
	-9.470006e-04,	/*H[208]=H[48]*/
	-1.114921e-03,	/*H[209]=H[47]*/
	-1.180116e-03,	/*H[210]=H[46]*/
	-1.145982e-03,	/*H[211]=H[45]*/
	-1.023689e-03,	/*H[212]=H[44]*/
	-8.306289e-04,	/*H[213]=H[43]*/
	-5.884650e-04,	/*H[214]=H[42]*/
	-3.209938e-04,	/*H[215]=H[41]*/
	-5.200508e-05,	/*H[216]=H[40]*/
	1.966780e-04,	/*H[217]=H[39]*/
	4.068290e-04,	/*H[218]=H[38]*/
	5.650086e-04,	/*H[219]=H[37]*/
	6.632529e-04,	/*H[220]=H[36]*/
	6.992420e-04,	/*H[221]=H[35]*/
	6.759813e-04,	/*H[222]=H[34]*/
	6.010622e-04,	/*H[223]=H[33]*/
	4.856045e-04,	/*H[224]=H[32]*/
	3.429959e-04,	/*H[225]=H[31]*/
	1.875562e-04,	/*H[226]=H[30]*/
	3.324734e-05,	/*H[227]=H[29]*/
	-1.074653e-04,	/*H[228]=H[28]*/
	-2.245151e-04,	/*H[229]=H[27]*/
	-3.108444e-04,	/*H[230]=H[26]*/
	-3.626970e-04,	/*H[231]=H[25]*/
	-3.795983e-04,	/*H[232]=H[24]*/
	-3.640535e-04,	/*H[233]=H[23]*/
	-3.210201e-04,	/*H[234]=H[22]*/
	-2.572197e-04,	/*H[235]=H[21]*/
	-1.803691e-04,	/*H[236]=H[20]*/
	-9.840435e-05,	/*H[237]=H[19]*/
	-1.876897e-05,	/*H[238]=H[18]*/
	5.217813e-05,	/*H[239]=H[17]*/
	1.095933e-04,	/*H[240]=H[16]*/
	1.503960e-04,	/*H[241]=H[15]*/
	1.733313e-04,	/*H[242]=H[14]*/
	1.788606e-04,	/*H[243]=H[13]*/
	1.689094e-04,	/*H[244]=H[12]*/
	1.465118e-04,	/*H[245]=H[11]*/
	1.153945e-04,	/*H[246]=H[10]*/
	7.954815e-05,	/*H[247]=H[9]*/
	4.282523e-05,	/*H[248]=H[8]*/
	8.601209e-06,	/*H[249]=H[7]*/
	-2.047689e-05,	/*H[250]=H[6]*/
	-4.264050e-05,	/*H[251]=H[5]*/
	-5.704556e-05,	/*H[252]=H[4]*/
	-6.372239e-05,	/*H[253]=H[3]*/
	-6.344600e-05,	/*H[254]=H[2]*/
	-5.754926e-05,	/*H[255]=H[1]*/
	-4.770475e-05,	/*H[256]=H[0]*/
};

// Taps = 256 LPF 
// fs   = 12000 Hz
// fc   = 500 Hz, 60.0[dB]
// Gain = 1.0

static float LPF[257] = {
    -3.58651e-19,  // h[0]
    1.57539e-06,  // h[1]
    6.57992e-06,  // h[2]
    1.44304e-05,  // h[3]
    2.32214e-05,  // h[4]
    2.99242e-05,  // h[5]
    3.07922e-05,  // h[6]
    2.19351e-05,  // h[7]
    1.04836e-10,  // h[8]
    -3.71193e-05,  // h[9]
    -8.9635e-05,  // h[10]
    -0.000155368,  // h[11]
    -0.000229488,  // h[12]
    -0.00030455,  // h[13]
    -0.000370875,  // h[14]
    -0.00041727,  // h[15]
    -0.000432068,  // h[16]
    -0.000404409,  // h[17]
    -0.000325663,  // h[18]
    -0.000190865,  // h[19]
    -6.99907e-10,  // h[20]
    0.000241006,  // h[21]
    0.000519759,  // h[22]
    0.000817425,  // h[23]
    0.00110944,  // h[24]
    0.00136689,  // h[25]
    0.00155856,  // h[26]
    0.00165355,  // h[27]
    0.00162428,  // h[28]
    0.00144962,  // h[29]
    0.00111797,  // h[30]
    0.000629881,  // h[31]
    1.98026e-09,  // h[32]
    -0.000742025,  // h[33]
    -0.00155184,  // h[34]
    -0.00237205,  // h[35]
    -0.00313524,  // h[36]
    -0.00376846,  // h[37]
    -0.00419862,  // h[38]
    -0.00435886,  // h[39]
    -0.00419512,  // h[40]
    -0.00367257,  // h[41]
    -0.00278122,  // h[42]
    -0.00154018,  // h[43]
    -4.16803e-09,  // h[44]
    0.00175733,  // h[45]
    0.00362107,  // h[46]
    0.00545707,  // h[47]
    0.00711585,  // h[48]
    0.00844286,  // h[49]
    0.00929045,  // h[50]
    0.0095307,  // h[51]
    0.00906821,  // h[52]
    0.00785168,  // h[53]
    0.00588331,  // h[54]
    0.00322493,  // h[55]
    7.4072e-09,  // h[56]
    -0.00360907,  // h[57]
    -0.00736876,  // h[58]
    -0.011007,  // h[59]
    -0.0142305,  // h[60]
    -0.0167453,  // h[61]
    -0.0182797,  // h[62]
    -0.0186082,  // h[63]
    -0.0175736,  // h[64]
    -0.0151068,  // h[65]
    -0.011241,  // h[66]
    -0.00612049,  // h[67]
    -1.16392e-08,  // h[68]
    0.00676284,  // h[69]
    0.013725,  // h[70]
    0.020383,  // h[71]
    0.0262059,  // h[72]
    0.0306725,  // h[73]
    0.0333119,  // h[74]
    0.0337448,  // h[75]
    0.03172,  // h[76]
    0.0271464,  // h[77]
    0.0201148,  // h[78]
    0.0109085,  // h[79]
    1.65335e-08,  // h[80]
    -0.0119664,  // h[81]
    -0.0242065,  // h[82]
    -0.0358416,  // h[83]
    -0.0459547,  // h[84]
    -0.0536549,  // h[85]
    -0.0581452,  // h[86]
    -0.0587896,  // h[87]
    -0.0551746,  // h[88]
    -0.0471595,  // h[89]
    -0.0349116,  // h[90]
    -0.0189221,  // h[91]
    -2.1505e-08,  // h[92]
    0.0207566,  // h[93]
    0.0420134,  // h[94]
    0.0622728,  // h[95]
    0.0799654,  // h[96]
    0.0935541,  // h[97]
    0.101645,  // h[98]
    0.103097,  // h[99]
    0.0971259,  // h[100]
    0.0833905,  // h[101]
    0.0620577,  // h[102]
    0.0338401,  // h[103]
    2.58192e-08,  // h[104]
    -0.0376805,  // h[105]
    -0.0769652,  // h[106]
    -0.115263,  // h[107]
    -0.149753,  // h[108]
    -0.17754,  // h[109]
    -0.195813,  // h[110]
    -0.202021,  // h[111]
    -0.194035,  // h[112]
    -0.170299,  // h[113]
    -0.129954,  // h[114]
    -0.072931,  // h[115]
    -2.87589e-08,  // h[116]
    0.0872234,  // h[117]
    0.18632,  // h[118]
    0.294154,  // h[119]
    0.407006,  // h[120]
    0.520736,  // h[121]
    0.630982,  // h[122]
    0.733369,  // h[123]
    0.823731,  // h[124]
    0.898317,  // h[125]
    0.953987,  // h[126]
    0.988372,  // h[127]
    1,  // h[128]
    0.988372,  // h[129]
    0.953987,  // h[130]
    0.898317,  // h[131]
    0.823731,  // h[132]
    0.733369,  // h[133]
    0.630982,  // h[134]
    0.520736,  // h[135]
    0.407006,  // h[136]
    0.294154,  // h[137]
    0.18632,  // h[138]
    0.0872234,  // h[139]
    -2.87589e-08,  // h[140]
    -0.072931,  // h[141]
    -0.129954,  // h[142]
    -0.170299,  // h[143]
    -0.194035,  // h[144]
    -0.202021,  // h[145]
    -0.195813,  // h[146]
    -0.17754,  // h[147]
    -0.149753,  // h[148]
    -0.115263,  // h[149]
    -0.0769652,  // h[150]
    -0.0376805,  // h[151]
    2.58192e-08,  // h[152]
    0.0338401,  // h[153]
    0.0620577,  // h[154]
    0.0833905,  // h[155]
    0.0971259,  // h[156]
    0.103097,  // h[157]
    0.101645,  // h[158]
    0.0935541,  // h[159]
    0.0799654,  // h[160]
    0.0622728,  // h[161]
    0.0420134,  // h[162]
    0.0207566,  // h[163]
    -2.1505e-08,  // h[164]
    -0.0189221,  // h[165]
    -0.0349116,  // h[166]
    -0.0471595,  // h[167]
    -0.0551746,  // h[168]
    -0.0587896,  // h[169]
    -0.0581452,  // h[170]
    -0.0536549,  // h[171]
    -0.0459547,  // h[172]
    -0.0358416,  // h[173]
    -0.0242065,  // h[174]
    -0.0119664,  // h[175]
    1.65335e-08,  // h[176]
    0.0109085,  // h[177]
    0.0201148,  // h[178]
    0.0271464,  // h[179]
    0.03172,  // h[180]
    0.0337448,  // h[181]
    0.0333119,  // h[182]
    0.0306725,  // h[183]
    0.0262059,  // h[184]
    0.020383,  // h[185]
    0.013725,  // h[186]
    0.00676284,  // h[187]
    -1.16392e-08,  // h[188]
    -0.00612049,  // h[189]
    -0.011241,  // h[190]
    -0.0151068,  // h[191]
    -0.0175736,  // h[192]
    -0.0186082,  // h[193]
    -0.0182797,  // h[194]
    -0.0167453,  // h[195]
    -0.0142305,  // h[196]
    -0.011007,  // h[197]
    -0.00736876,  // h[198]
    -0.00360907,  // h[199]
    7.4072e-09,  // h[200]
    0.00322493,  // h[201]
    0.00588331,  // h[202]
    0.00785168,  // h[203]
    0.00906821,  // h[204]
    0.0095307,  // h[205]
    0.00929045,  // h[206]
    0.00844286,  // h[207]
    0.00711585,  // h[208]
    0.00545707,  // h[209]
    0.00362107,  // h[210]
    0.00175733,  // h[211]
    -4.16803e-09,  // h[212]
    -0.00154018,  // h[213]
    -0.00278122,  // h[214]
    -0.00367257,  // h[215]
    -0.00419512,  // h[216]
    -0.00435886,  // h[217]
    -0.00419862,  // h[218]
    -0.00376846,  // h[219]
    -0.00313524,  // h[220]
    -0.00237205,  // h[221]
    -0.00155184,  // h[222]
    -0.000742025,  // h[223]
    1.98026e-09,  // h[224]
    0.000629881,  // h[225]
    0.00111797,  // h[226]
    0.00144962,  // h[227]
    0.00162428,  // h[228]
    0.00165355,  // h[229]
    0.00155856,  // h[230]
    0.00136689,  // h[231]
    0.00110944,  // h[232]
    0.000817425,  // h[233]
    0.000519759,  // h[234]
    0.000241006,  // h[235]
    -6.99907e-10,  // h[236]
    -0.000190865,  // h[237]
    -0.000325663,  // h[238]
    -0.000404409,  // h[239]
    -0.000432068,  // h[240]
    -0.00041727,  // h[241]
    -0.000370875,  // h[242]
    -0.00030455,  // h[243]
    -0.000229488,  // h[244]
    -0.000155368,  // h[245]
    -8.9635e-05,  // h[246]
    -3.71193e-05,  // h[247]
    1.04836e-10,  // h[248]
    2.19351e-05,  // h[249]
    3.07922e-05,  // h[250]
    2.99242e-05,  // h[251]
    2.32214e-05,  // h[252]
    1.44304e-05,  // h[253]
    6.57992e-06,  // h[254]
    1.57539e-06,  // h[255]
    -3.58651e-19   // h[256]
};

// Taps = 256 LPF 
// fs   = 12000 Hz
// fc   = 300 Hz, 60.0[dB]
// Gain = 1.0

static float LPF_300[257] = {
    -6.56443e-19,  // h[0]
    2.422e-06,  // h[1]
    8.87211e-06,  // h[2]
    1.76063e-05,  // h[3]
    2.62679e-05,  // h[4]
    3.20208e-05,  // h[5]
    3.17177e-05,  // h[6]
    2.20965e-05,  // h[7]
    5.24181e-11,  // h[8]
    -3.73926e-05,  // h[9]
    -9.23292e-05,  // h[10]
    -0.000166254,  // h[11]
    -0.000259595,  // h[12]
    -0.000371577,  // h[13]
    -0.000500073,  // h[14]
    -0.000641509,  // h[15]
    -0.000790818,  // h[16]
    -0.000941464,  // h[17]
    -0.00108554,  // h[18]
    -0.00121394,  // h[19]
    -0.0013166,  // h[20]
    -0.00138281,  // h[21]
    -0.00140165,  // h[22]
    -0.00136238,  // h[23]
    -0.00125499,  // h[24]
    -0.00107074,  // h[25]
    -0.000802702,  // h[26]
    -0.00044633,  // h[27]
    -7.31677e-10,  // h[28]
    0.000534502,  // h[29]
    0.00115157,  // h[30]
    0.00184144,  // h[31]
    0.00259,  // h[32]
    0.00337876,  // h[33]
    0.0041849,  // h[34]
    0.00498159,  // h[35]
    0.00573847,  // h[36]
    0.00642227,  // h[37]
    0.00699769,  // h[38]
    0.00742844,  // h[39]
    0.00767837,  // h[40]
    0.00771285,  // h[41]
    0.00750018,  // h[42]
    0.00701308,  // h[43]
    0.00623018,  // h[44]
    0.00513753,  // h[45]
    0.00372991,  // h[46]
    0.00201213,  // h[47]
    2.56434e-09,  // h[48]
    -0.00227891,  // h[49]
    -0.00478484,  // h[50]
    -0.0074658,  // h[51]
    -0.0102579,  // h[52]
    -0.0130861,  // h[53]
    -0.0158656,  // h[54]
    -0.0185034,  // h[55]
    -0.0209006,  // h[56]
    -0.0229546,  // h[57]
    -0.0245626,  // h[58]
    -0.0256244,  // h[59]
    -0.0260463,  // h[60]
    -0.0257442,  // h[61]
    -0.0246477,  // h[62]
    -0.0227036,  // h[63]
    -0.0198792,  // h[64]
    -0.0161652,  // h[65]
    -0.0115789,  // h[66]
    -0.00616553,  // h[67]
    -5.81959e-09,  // h[68]
    0.00681262,  // h[69]
    0.0141375,  // h[70]
    0.0218112,  // h[71]
    0.029644,  // h[72]
    0.037423,  // h[73]
    0.0449165,  // h[74]
    0.0518791,  // h[75]
    0.0580573,  // h[76]
    0.0631968,  // h[77]
    0.0670493,  // h[78]
    0.0693805,  // h[79]
    0.0699779,  // h[80]
    0.0686588,  // h[81]
    0.0652782,  // h[82]
    0.059736,  // h[83]
    0.0519837,  // h[84]
    0.0420302,  // h[85]
    0.0299464,  // h[86]
    0.0158686,  // h[87]
    9.94161e-09,  // h[88]
    -0.0173886,  // h[89]
    -0.0359609,  // h[90]
    -0.0553181,  // h[91]
    -0.0750043,  // h[92]
    -0.0945136,  // h[93]
    -0.113299,  // h[94]
    -0.130781,  // h[95]
    -0.146361,  // h[96]
    -0.159437,  // h[97]
    -0.169408,  // h[98]
    -0.1757,  // h[99]
    -0.17777,  // h[100]
    -0.17513,  // h[101]
    -0.167352,  // h[102]
    -0.154088,  // h[103]
    -0.135077,  // h[104]
    -0.110158,  // h[105]
    -0.0792786,  // h[106]
    -0.0424996,  // h[107]
    -1.34916e-08,  // h[108]
    0.0479217,  // h[109]
    0.100849,  // h[110]
    0.158252,  // h[111]
    0.219491,  // h[112]
    0.283831,  // h[113]
    0.35045,  // h[114]
    0.418452,  // h[115]
    0.486886,  // h[116]
    0.554761,  // h[117]
    0.621067,  // h[118]
    0.684793,  // h[119]
    0.744947,  // h[120]
    0.800577,  // h[121]
    0.850791,  // h[122]
    0.894772,  // h[123]
    0.931799,  // h[124]
    0.961258,  // h[125]
    0.98266,  // h[126]
    0.995647,  // h[127]
    1,  // h[128]
    0.995647,  // h[129]
    0.98266,  // h[130]
    0.961258,  // h[131]
    0.931799,  // h[132]
    0.894772,  // h[133]
    0.850791,  // h[134]
    0.800577,  // h[135]
    0.744947,  // h[136]
    0.684793,  // h[137]
    0.621067,  // h[138]
    0.554761,  // h[139]
    0.486886,  // h[140]
    0.418452,  // h[141]
    0.35045,  // h[142]
    0.283831,  // h[143]
    0.219491,  // h[144]
    0.158252,  // h[145]
    0.100849,  // h[146]
    0.0479217,  // h[147]
    -1.34916e-08,  // h[148]
    -0.0424996,  // h[149]
    -0.0792786,  // h[150]
    -0.110158,  // h[151]
    -0.135077,  // h[152]
    -0.154088,  // h[153]
    -0.167352,  // h[154]
    -0.17513,  // h[155]
    -0.17777,  // h[156]
    -0.1757,  // h[157]
    -0.169408,  // h[158]
    -0.159437,  // h[159]
    -0.146361,  // h[160]
    -0.130781,  // h[161]
    -0.113299,  // h[162]
    -0.0945136,  // h[163]
    -0.0750043,  // h[164]
    -0.0553181,  // h[165]
    -0.0359609,  // h[166]
    -0.0173886,  // h[167]
    9.94161e-09,  // h[168]
    0.0158686,  // h[169]
    0.0299464,  // h[170]
    0.0420302,  // h[171]
    0.0519837,  // h[172]
    0.059736,  // h[173]
    0.0652782,  // h[174]
    0.0686588,  // h[175]
    0.0699779,  // h[176]
    0.0693805,  // h[177]
    0.0670493,  // h[178]
    0.0631968,  // h[179]
    0.0580573,  // h[180]
    0.0518791,  // h[181]
    0.0449165,  // h[182]
    0.037423,  // h[183]
    0.029644,  // h[184]
    0.0218112,  // h[185]
    0.0141375,  // h[186]
    0.00681262,  // h[187]
    -5.81959e-09,  // h[188]
    -0.00616553,  // h[189]
    -0.0115789,  // h[190]
    -0.0161652,  // h[191]
    -0.0198792,  // h[192]
    -0.0227036,  // h[193]
    -0.0246477,  // h[194]
    -0.0257442,  // h[195]
    -0.0260463,  // h[196]
    -0.0256244,  // h[197]
    -0.0245626,  // h[198]
    -0.0229546,  // h[199]
    -0.0209006,  // h[200]
    -0.0185034,  // h[201]
    -0.0158656,  // h[202]
    -0.0130861,  // h[203]
    -0.0102579,  // h[204]
    -0.0074658,  // h[205]
    -0.00478484,  // h[206]
    -0.00227891,  // h[207]
    2.56434e-09,  // h[208]
    0.00201213,  // h[209]
    0.00372991,  // h[210]
    0.00513753,  // h[211]
    0.00623018,  // h[212]
    0.00701308,  // h[213]
    0.00750018,  // h[214]
    0.00771285,  // h[215]
    0.00767837,  // h[216]
    0.00742844,  // h[217]
    0.00699769,  // h[218]
    0.00642227,  // h[219]
    0.00573847,  // h[220]
    0.00498159,  // h[221]
    0.0041849,  // h[222]
    0.00337876,  // h[223]
    0.00259,  // h[224]
    0.00184144,  // h[225]
    0.00115157,  // h[226]
    0.000534502,  // h[227]
    -7.31677e-10,  // h[228]
    -0.00044633,  // h[229]
    -0.000802702,  // h[230]
    -0.00107074,  // h[231]
    -0.00125499,  // h[232]
    -0.00136238,  // h[233]
    -0.00140165,  // h[234]
    -0.00138281,  // h[235]
    -0.0013166,  // h[236]
    -0.00121394,  // h[237]
    -0.00108554,  // h[238]
    -0.000941464,  // h[239]
    -0.000790818,  // h[240]
    -0.000641509,  // h[241]
    -0.000500073,  // h[242]
    -0.000371577,  // h[243]
    -0.000259595,  // h[244]
    -0.000166254,  // h[245]
    -9.23292e-05,  // h[246]
    -3.73926e-05,  // h[247]
    5.24181e-11,  // h[248]
    2.20965e-05,  // h[249]
    3.17177e-05,  // h[250]
    3.20208e-05,  // h[251]
    2.62679e-05,  // h[252]
    1.76063e-05,  // h[253]
    8.87211e-06,  // h[254]
    2.422e-06,  // h[255]
    -6.56443e-19   // h[256]
};

double I_lpf(void)
{
	double res = 0.0;
	int i;
    for(i=0;i<257;i++)res = res + I_bu[i] * LPF[i];
	return res;
}

double Q_lpf(void) 
{
	double res = 0.0;
	int i;
    for(i=0;i<257;i++)res = res + Q_bu[i] * LPF[i];
	return res;
}


//=======================================================================================
//============================  Picture demodulator =====================================
//=======================================================================================
void demodulate_image(float input)
{
static float o_Q_dat,o_I_dat;  //Must be static when inside a function
static float Q_dat,I_dat;
static float pix;
static BYTE  pix_byte;
static float amplitude;
static int   p;	

        
	do_nco_step();
	make_I_and_Q((double)input);
	Q_dat = Q_lpf();
	I_dat = I_lpf();

amplitude = I_dat * I_dat + Q_dat * Q_dat ;

if(amplitude < 0.0000000001)amplitude = 0.0000000001;
    
	
pix = (Q_dat * o_I_dat - I_dat * o_Q_dat) / amplitude;

	o_Q_dat = Q_dat;
	o_I_dat = I_dat;  

pix = 2.1*pix*2.3*256 + 128;
if(pix>255)pix=255;
if(pix<0)pix=0;
pix_byte = pix;

//Note: picW and picH will be derived from the receive callback as they are global variables

if(FAX == TRUE)goto rx_fax;	
           if(pixel>picW*30-1)    
			   {                   
				pixel=0;
				if(line>picH-1){line=0;PicStart = FALSE;} //end of the picture
				line++;            
			   }		

			
                		 pixR[pixel+picW*10*line*3]= pix_byte;  //collect all the samples one by one

if(PicStart == TRUE)
  {
   if(pixel==picW*30-1)
      {
	   for(p=0;p<picW*30;p++)
	    {
         pix_processed[p+picW*10*line*3] =  pixR[p+picW*10*line*3]; 
	    }

       for(p=0;p<picW*10;p++)           //For immediate display as samples come in - decimate by 10
            {
             pix_display[p/10+picW*line] =   pix_processed[p+        picW*10*line*3]             //Red
								           + pix_processed[p+picW*10+picW*10*line*3] * 256       //Green
								           + pix_processed[p+picW*20+picW*10*line*3] * 256*256;  //Blue (or vice-versa!) - just ensure consistency at receive end!
            }		
        } 
      } 
goto end;
rx_fax:

           if(pixel>picW*10-1)    
			   {                   
				pixel=0;
				if(line>picH-1){line=0;PicStart = FALSE;} //end of the picture
				line++;            
			   }
			
                		 pixR[pixel+picW*10*line]= pix_byte;  //collect all the samples one by one

if(PicStart == TRUE)
  {
   if(pixel==picW*10-1)
      {
	   for(p=0;p<picW*10;p++)
	    {
          pix_processed[p+picW*10*line] =  pixR[p+picW*10*line];  
	    }

       for(p=0;p<picW*10;p++)           //For immediate display as samples come in - decimate by 10
            {
             pix_display[p/10+picW*line] =   pix_processed[p+ picW*10*line]*(1+256+256*256);             //Red
								            
            }		
        } 
      } 

end:
//;  
  pixel++;
	
 }
   

//===========================================================================================================                      
//=================================== Picture modulator =====================================================
//===========================================================================================================

float modulate_image(void)
{
	static float phase, output, fAngle;
 
    Sending_pic = TRUE; 
   //This is about as simple as it gets!	
   
		     static int i;
			 BYTE color;                  //Must be BYTE
	         BYTE red, green, blue;
			 float frequency;

             tpicW=640;tpicH=480;

             if(RXbutton == TRUE)   //Reset pixel and line counters to zero
               {
				Image_mode = FALSE;
				i=0;
				line_counter=tpicH;
               }

              if(line_counter==0)line_counter=tpicH; // "line_counter" will likely be 0 at startup so we need it to be tpicH - "line_counter" is the counter for the pic progress bar

            GetObject (hTmpBmp, sizeof(bm), &bm);
            DWORD *pBits = (DWORD*) bm.bmBits;    //Point to bitmap bits - Must be DWORD to suit 32 bit bitmap



		if(VERYLARGE_PIC == TRUE) {SMALL_PIC = FALSE; LARGE_PIC = FALSE; FAX = FALSE; pic_decimate=1;}
	      else
		if(LARGE_PIC == TRUE)     {SMALL_PIC = FALSE; VERYLARGE_PIC = FALSE; FAX = FALSE; pic_decimate=2;}
	      else
		if(SMALL_PIC == TRUE)     {LARGE_PIC = FALSE; VERYLARGE_PIC = FALSE; FAX = FALSE; pic_decimate=4;}
	      else
		if(FAX       == TRUE)     {LARGE_PIC = FALSE; VERYLARGE_PIC = FALSE; SMALL_PIC = FALSE; pic_decimate=1;goto fax;}

            {
//Small and large colour pics 
           if(i>tpicW*30-1)
			   {                
				i=0;
				line_counter-=pic_decimate; 
				if(line_counter < pic_decimate){PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);PostMessage(g_hwndRXbutton,WM_LBUTTONDOWN,0,0);}			           
			   }
			i+=pic_decimate;
			
	 
				if(i<tpicW*10)  color = pBits[ i/10             + tpicW*line_counter];             //blue   = first 1/3rd of the line (Windoze convention!)
				if(i>tpicW*10-1)color = pBits[(i-tpicW*10-1)/10 + tpicW*line_counter]/256;         //green = second 1/3rd of the line
                if(i>tpicW*20-1)color = pBits[(i-tpicW*20-1)/10 + tpicW*line_counter]/(256*256);   //red  = last 1/3rd of the line

				frequency = 950 + channel_offset + 1.5*color;//3.137*color;  // channel offset = 1150-950=200

                phase  = 2*3.14159*frequency/FS;
	            output   = sin(fAngle);
                fAngle = fAngle + phase;
	   	        if(fAngle>=(2*3.14159))fAngle = fAngle - 2*3.14159;    

               if(i==tpicW*30)
				{
                 hPenMarker    = CreatePen (PS_DASH, 1,  0x0000FF00);            //picture send "progress bar"
                 hOldPenmarker = (HPEN)SelectObject (hMarkerDC, hPenMarker);

                 MoveToEx (hMarkerDC,0,  tpicH-line_counter, NULL);  
                 LineTo   (hMarkerDC,10, tpicH-line_counter);
   
                 SelectObject (hMarkerDC, hOldPenmarker);
                 DeleteObject (hPenMarker);	
		     
 			     if(line_counter < pic_decimate+2)PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);
				 BitBlt (hdcPic, tpicW-10, 0, 10, tpicH, hMarkerDC, 0, 0, SRCCOPY); //copy marker onto RH side of screen
			 
                }goto skip_fax;
fax:
//Fax mode
           if(i>tpicW*10-1)
			   {                
				i=0;
				line_counter-=pic_decimate; 
				if(line_counter < pic_decimate){PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);PostMessage(g_hwndRXbutton,WM_LBUTTONDOWN,0,0);}			           
			   }
			i+=pic_decimate;
			

				blue  = pBits[i/10 + tpicW*line_counter];  
                green = pBits[i/10 + tpicW*line_counter]/(256);
                red   = pBits[i/10 + tpicW*line_counter]/(256*256);
                color = 0.3*red +0.6*green + 0.1*blue;

				frequency = 950 + channel_offset + 1.5*color;//3.137*color;

                phase  = 2*3.14159*frequency/FS;
	            output   = sin(fAngle);
                fAngle = fAngle + phase;
	   	        if(fAngle>=(2*3.14159))fAngle = fAngle - 2*3.14159;    

               if(i==tpicW*10)
				{
                 hPenMarker    = CreatePen (PS_DASH, 1,  0x0000FF00);            //picture send "progress bar"
                 hOldPenmarker = (HPEN)SelectObject (hMarkerDC, hPenMarker);

                 MoveToEx (hMarkerDC,0,  tpicH-line_counter, NULL);  
                 LineTo   (hMarkerDC,10, tpicH-line_counter);
   
                 SelectObject (hMarkerDC, hOldPenmarker);
                 DeleteObject (hPenMarker);	
		     
 			     if(line_counter < pic_decimate+2)PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);
				 BitBlt (hdcPic, tpicW-10, 0, 10, tpicH, hMarkerDC, 0, 0, SRCCOPY); //copy marker onto RH side of screen
			 
                }		
skip_fax:
;				
		    }		   
 return output;  
}	



//==========================================================================================================
// These functions transfer control from the main program callback routine. They must go AFTER the actual
// send/receive modules as I don't know how else to do it
//==========================================================================================================




void send_pic(void)
{
  if(TXwindowOpen==TRUE)MessageBox(hwnd,"Window already open","Warning!",MB_OK | MB_ICONWARNING);
  if(TXwindowOpen==FALSE)CreateDialog(hThisInstance, MAKEINTRESOURCE(DLG_IMAGE_TX), NULL, (DLGPROC)IMAGE_TX_DlgProc);	  
}

void remote_send_pic(void)
{
  if(TXwindowOpen==TRUE)MessageBox(hwnd,"Window already open","Warning!",MB_OK | MB_ICONWARNING);
  if(TXwindowOpen==FALSE)CreateDialog(hThisInstance, MAKEINTRESOURCE(DLG_IMAGE_REMOTE_TX), NULL, (DLGPROC)IMAGE_REMOTE_TX_DlgProc);	  
}

void send_webcam(void)
{
  if(TXwindowOpen==TRUE)MessageBox(hwnd,"Window already open","Warning!",MB_OK | MB_ICONWARNING);	 
  if(TXwindowOpen==FALSE)CreateDialog(hThisInstance, MAKEINTRESOURCE(DLG_WEBCAM_TX), NULL, (DLGPROC)WEBCAM_TX_DlgProc); //DO NOT use DialogBox, otherwise it will not respond remotely! 
}



void receive_pic(void)
{
  SendMessage(hRX,WM_CLOSE,0,0);            //Send a WM_CLOSE message to shut down the existing RX dialog
  memset(pix_display,0,640*482*4);          //Clear the pixel buffer
  DestroyWindow(hRX);                       //Don't forget to delete the old Dialog window, hRX	!
  PicStart = TRUE;                          //Tell the rx dialog to start receiving straight away
  line = 0;			                        //Reset the pic to start at the top 
  if(VERYLARGE_PIC == TRUE) {picW=640; picH=480;}
	else
  if(LARGE_PIC     == TRUE) {picW=320; picH=240;}
	else
  if(SMALL_PIC     == TRUE) {picW=160; picH=120;}
	else
  if(FAX           == TRUE) {picW=640; picH=480;} 


  hRX = CreateDialog(hThisInstance, MAKEINTRESOURCE(DLG_IMAGE_RX), NULL, (DLGPROC)IMAGE_RX_DlgProc);//Start a new one
}  
